//OHSAT GAMES MEGATILER TUTORIAL - COINS- https://www.ohsat.com/tutorial/megatiler/megatiler-5/
//MEGATEAMWORK Makes the MEGADREAM Work 
//SGDK Version: 2.0 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>
 
//array defines for tile usage

#define SOLID_TILE 1    // barrier tile
#define SPAWN_TILE 4    // value for player sprite for use in array
#define COIN_TILE 6     //value for coin sprite
#define MAX_COINS 3     //max number of coins on the map


//tile measurement defines

#define TILESIZE 8      // pixel value tile size
#define MAP_WIDTH 8     // tile width
#define MAP_HEIGHT 8    // tile height

//Sprite animation defines

#define ANIM_DOWN 0
#define ANIM_UP 1
#define ANIM_SIDE 2

// 0 is grass, 1 is solid, 4 is spawn/player, 5 is exit, 6 is coin.

u8 level1[8][8] = {
    {6, 0, 0, 0, 0, 0, 0, 6},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 1, 1, 0, 0, 0},
    {4, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 6}
};

//globals

u8 x = 0;
u8 y = 0;
u8 t = 0;
u8 i = 0;
u8 coinNum = 0;

int getTileAt(u8 X, u8 Y);

typedef struct {
    u8 x;
    u8 y; 
} Point;

typedef enum { up, down, left, right, none } moveDirection;

typedef struct {
    Point pos;
    Point tilePos;
    int w; 
    int h;
    int health;
    bool moving;
    moveDirection dir;
    Sprite *sprite;
    char name[6];
} Entity;

Entity player = {{0, 0}, {0, 0}, 8, 8, 0, FALSE, none, NULL, "PLAYER"};

typedef struct
{
    Point pos;
    u8 w;
    u8 h;
    Sprite *sprite;
    u8 health;
} Coin;

Coin coins[MAX_COINS];
Coin *c = coins;
Coin *coinToCheck; 

void loadLevel();
void movePlayer(moveDirection Direction);
void myJoyHandler(u16 joy, u16 changed, u16 state);

int main()
{   
    JOY_init();
    JOY_setEventHandler(&myJoyHandler);
    loadLevel();
   
    while(1)
    {
        if(player.moving == TRUE){
        switch(player.dir){
            case up:
                player.pos.y -= 1;
                break;

            case down: 
                player.pos.y += 1;
                break;

            case left: 
                player.pos.x -= 1;
                break;

            case right: 
                player.pos.x += 1;
                break;

                break;
            default:
                break;
            }
        }

        SPR_update(); 

        if (player.pos.x % TILESIZE == 0 && player.pos.y % TILESIZE == 0)
        {
            player.moving = FALSE;
        }
        
        SPR_setPosition(player.sprite, player.pos.x, player.pos.y);

        for (i = 0; i < MAX_COINS; i++)
        {
            coinToCheck = &coins[i];
            if ((player.pos.x < coinToCheck->pos.x + coinToCheck->w 
                && player.pos.x + player.w > coinToCheck->pos.x 
                && player.pos.y <   coinToCheck->pos.y + coinToCheck->h 
                && player.pos.y + player.h > coinToCheck->pos.y) == TRUE)
            {
                if (coinToCheck->health >0)
                {
                    coinToCheck->health = 0;
                    SPR_setVisibility(coinToCheck->sprite, HIDDEN);
                }
                
            }
        }

        SYS_doVBlankProcess();
    }

    return 0;
}


int getTileAt(u8 X, u8 Y)
{
    
    return level1[Y][X];
}

void loadLevel()
{
    SPR_init();

    for (y = 0; y < MAP_HEIGHT; y++) {
        for (x = 0; x < MAP_WIDTH; x++) {
            t = level1[y][x];

            if (t == SPAWN_TILE)
            {
                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = x * TILESIZE;
                player.pos.y = y * TILESIZE;

                player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));

                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }
            else if (t == COIN_TILE)
            {
                if (coinNum < MAX_COINS)
                {
                    c = &coins[coinNum];
                    c->pos.x = x * TILESIZE;
                    c->pos.y = y * TILESIZE;
                    c->w = 8;
                    c->h = 8;
                    c->health = 1;
                    c->sprite = SPR_addSprite(&coin, c->pos.x, c->pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
                    coinNum++;

                    VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
                }
                
            }
            
            else {
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
            }
        }
    }

    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);
}

void movePlayer(moveDirection Direction)
{
    if (!player.moving)
    {
        switch(Direction)
        {
            case up:
                if (player.tilePos.y > 0 &&
                    getTileAt(player.tilePos.x, player.tilePos.y - 1) != SOLID_TILE)
                {
                    player.tilePos.y--;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_UP);
                }
                break;

            case down:
                if (player.tilePos.y < MAP_HEIGHT - 1 &&
                    getTileAt(player.tilePos.x, player.tilePos.y + 1) != SOLID_TILE)
                {
                    player.tilePos.y++;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_DOWN);
                }
                break;

            case left:
                if (player.tilePos.x > 0 &&
                    getTileAt(player.tilePos.x - 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x--;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_SIDE);
                    SPR_setHFlip(player.sprite, TRUE);
                }
                break;

            case right:
                if (player.tilePos.x < MAP_WIDTH - 1 &&
                    getTileAt(player.tilePos.x + 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x++;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_SIDE);
                    SPR_setHFlip(player.sprite,FALSE);
                }
                break;

            default:
                break;
        }
    }
}

void myJoyHandler(u16 joy, u16 changed, u16 state)
{
    if (joy == JOY_1)
    {
        if (state & BUTTON_UP)
            movePlayer(up);
        else if (state & BUTTON_DOWN)
            movePlayer(down);
        else if (state & BUTTON_LEFT)
            movePlayer(left);
        else if (state & BUTTON_RIGHT)
            movePlayer(right);
    }
}


////////////////////NOTES////////////////////

/*

1. Add a sprite for COIN & then a #define for COIN_TILE

The coin sprite is in our Sprites folder so here's the entry in
resources.res if you're unable to figure out how to added it yourself. 

SPRITE coin "Sprites/coin.png" 1 1 NONE 20

The OHSAT lesson uses a value of 6 for the #define COIN_TILE because
Andrej is going to use the value 5 for an exit tile. 

#define COIN_TILE 6 

2. Using a Coin struct to handle the coin positioning in the level1 array

typedef struct
{
    Point pos;
    u8 w;
    u8 h;
    Sprite *sprite;
    u8 health;
} Coin;

3. Add a #define to cap the number of coins

The map is small so the OHSAT tutorial set the cap at 3. This can be changed later
if/when the map size grows. 

#define MAX_COINS 3
Coin coins[MAX_COINS];

Here's where I positioned these two lines in my code. 

//array defines for tile usage

#define SOLID_TILE 1    // barrier tile
#define SPAWN_TILE 4    // value for player sprite for use in array
#define COIN_TILE 6     //value for coin sprite
#define MAX_COINS 3     //max number of coins on the map

typedef struct
{
    Point pos;
    u8 w;
    u8 h;
    Sprite *sprite;
    u8 health;
} Coin;

Coin coins[MAX_COINS];

4. Updating loadLevel() function to spawn coin tiles

I'm feeling a bit lazy so I'm going to copy/paste from the OHSAT explanation and then 
I'll paste my completed code below for reference. 

Obviously, we will handle the spawning in loadLevel(). We already have an if-statement checking for the player spawn tile, so let’s add another condition checking for a coin tile:

if (t == SPAWN_TILE){
//...
}
else if(t == COIN_TILE){
//Spawn a coin
}
Here’s how we’ll spawn the coins. Whenever the loop encounters a coin tile, we first check whether we’ve already reached the total number of coins. If not, we grab the next free slot in the array and spawn a coin entity at the correct position. And…that’s it actually! It’s not that complicated. However, we will need a helper variable to keep track of the coin count; and we’ll also need a pointer for the current coin in the array. So, before we start the for loop, define these new variables (after we define x,y and t):

u8 coinNum = 0;
Coin *c = coins;
Now for the actual spawning. The stuff I’ve just explained looks like this in code:

//...
else if(t == COIN_TILE){
    if(coinNum < MAX_COINS){
        c = &coins[coinNum];
        c->pos.x = x * TILESIZE;
        c->pos.y = y * TILESIZE;
        c->w = 8;
        c->h = 8;
        c->health = 1;
        c->sprite = SPR_addSprite(&coin, c->pos.x, c->pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
        coinNum++;
    }
}

Like with the player, we get the correct position in pixels by multiplying the tile coordinates with TILESIZE. 
A health value of 1 implies that the coin hasn’t been collected yet. 
It’s important to increment coinNum at the end, because otherwise we would just overwrite the same coin in the array over and over.

We’re almost done now, but there’s still one thing we need to take care of. 
Like with the player spawn tile, we have to tell SGDK to draw a regular grass tile below the coin; otherwise we’d get a gap! 
So put this after the closing bracket of the if(coinNum < MAX_COINS) statement:

VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);

Here's what the full loadLevel() function looks like in context. 

void loadLevel()
{
    SPR_init();

    for (y = 0; y < MAP_HEIGHT; y++) {
        for (x = 0; x < MAP_WIDTH; x++) {
            t = level1[y][x];

            if (t == SPAWN_TILE)
            {
                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = x * TILESIZE;
                player.pos.y = y * TILESIZE;

                player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));

                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }
            else if (t == COIN_TILE)
            {
                if (coinNum < MAX_COINS)
                {
                    c = &coins[coinNum];
                    c->pos.x = x * TILESIZE;
                    c->pos.y = y * TILESIZE;
                    c->w = 8;
                    c->h = 8;
                    c->health = 1;
                    c->sprite = SPR_addSprite(&coin, c->pos.x, c->pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
                    coinNum++;

                    VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
                }
                
            }
            
            else {
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
            }
        }
    }

    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);
}

Note: I updated my array to include 3 coin tiles (top-left, top-right, bottom-right) and 
you may want to S/C/C here. I'm using BlastEm. Because of tile priority, I noticed something
mildly interesting. 

The top of the screen, for me, the coins would take priority over the player tile but at 
the bottom of the screen, the player tile seemed to take priority. It may behave differently on 
real hardware. It's not going to matter in the long run because we're going to make the coin tile
disappear after the player tile detects an overlap with the coin tile but it's was 
an interesting observation, IMO. 

4. Collecting Coins aka doing a barrel roll...I mean boundary check

We're going to added a boundary check in the while(1) loop to ensure the coin tile disappears
as the player/spawn tile passes over it. 

Added the *cointoCheck; variable to our Coin struct. 
Coin* coinToCheck;

Added the u8 i = 0; as a global

Now my current globals are the following: 

//globals

u8 x = 0;
u8 y = 0;
u8 t = 0;
u8 i = 0;
u8 coinNum = 0;

Code written out in the while(1) loop could likely be written into a contained function. 

We're using a for() statement to check against the MAX_COINS count. 
We start the count at 0 and stop at 3 since 3 is the current value associated with the #define MAX_COINS. 
The for() statement is going to look similar to the code we used to define the x/y parameters of the array. 

for(i = 0; i < MAX_COINS;){}

We'll use the *coinToCheck pointer and iterate through the coins array. 
I'll put the Coin struct below for context. 

typedef struct
{
    Point pos;
    u8 w;
    u8 h;
    Sprite *sprite;
    u8 health;
} Coin;

Coin coins[MAX_COINS];
Coin *c = coins;
Coin *coinToCheck; 

Within the for(i = 0; i < MAX_COINs; i++) expression we're going to start defining the parameters of the for() statement
using our the following:

coinToCheck = &coins[i];

We're then going to use an if() statement to start checking the boundary between the player position and the coin tile. 

There are a lot of && operators; therefore, I've written the code with to make it a little easier to read.
However, you could have written the entire if() expression on one line.  

coinToCheck = &coins[i];
    if ((player.pos.x < coinToCheck->pos.x + coinToCheck->w 
    && player.pos.x + player.w > coinToCheck->pos.x 
    && player.pos.y <   coinToCheck->pos.y + coinToCheck->h 
    && player.pos.y + player.h > coinToCheck->pos.y) == TRUE)
    {
    }


We're doing checks on the player's x/y position and checking against the boundaries of the coin tile's x/y values. 
We're taking into account the player tile's width and height as well as the width and height of the coin tile. 

The last thing we're going to do is add another if() statement inside the curly braces{} of the if() statement shown above. 

The expression of this if() statement is if(coinToCheck->health > 0){
}

The statement will be the following:

coinToCheck->health = 0;
SPR_setVisibility(coinToCheck->sprite, HIDDEN);

If you look at the Coin struct, you'll see that the value for health is c->health = 1 within our loadLevel() function. 
As we're doing the boundary check and we notice an overlap between player and coin tiles, we're going to take the expression that says 
if the coin health value is greater than zero, on an overlap, set the coin health value to zero, and set the sprite property to HIDDEN. 

With BlastEm, you can press 'V' to bring up the VDP VRAM Debugger. 
Pull it up and see what happens as the player moves over the coin tiles. 
VRAM tile management will be important if you're going to develop games with more graphical assets but
watching the VDP VRAM as you move around the map is a neat visual representation of what's happening
in VDP memory. 


*/

/////////EXPERIMENTATION IDEAS///////////////

/*

Play around in Aesprite/Libresprite with the current assets used in MEGATILER to make some color swaps.
They may be useful to spice up your game after we've completed the MEGATILER tutorial. 

*/

///////////ERROR HANDLING////////////////////

/*

I fixed the issue in the code above but I wanted to show you an example of a mistake I made. 

Old code: 

//...
                    c = &coins[coinNum];
                    c->pos.x = x * TILESIZE;
                    c->pos.y = y * TILESIZE;
                    c->w = 8;
                    c->h = 8;
                    c->health = 1;
                    c->sprite = SPR_addSprite(&coin, c->pos.x, c->pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE,));
                    coinNum++;
...//

Can you figure out what the issue is? 

*/